/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.init;

import com.blakebr0.mysticalagriculture.client.screen.ReprocessorScreen;
import com.blakebr0.mysticalagriculture.client.screen.SoulExtractorScreen;
import com.blakebr0.mysticalagriculture.client.screen.TinkeringTableScreen;
import com.blakebr0.mysticalagriculture.container.ReprocessorContainer;
import com.blakebr0.mysticalagriculture.container.SoulExtractorContainer;
import com.blakebr0.mysticalagriculture.container.TinkeringTableContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class ModContainerTypes {
    public static final List<Supplier<MenuType<?>>> ENTRIES = new ArrayList();
    public static final RegistryObject<MenuType<TinkeringTableContainer>> TINKERING_TABLE = ModContainerTypes.register("tinkering_table", () -> new MenuType(TinkeringTableContainer::create));
    public static final RegistryObject<MenuType<ReprocessorContainer>> REPROCESSOR = ModContainerTypes.register("reprocessor", () -> new MenuType((MenuType.MenuSupplier)((IContainerFactory)ReprocessorContainer::create)));
    public static final RegistryObject<MenuType<SoulExtractorContainer>> SOUL_EXTRACTOR = ModContainerTypes.register("soul_extractor", () -> new MenuType((MenuType.MenuSupplier)((IContainerFactory)SoulExtractorContainer::create)));

    @SubscribeEvent
    public void onRegisterContainerTypes(RegistryEvent.Register<MenuType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        ENTRIES.stream().map(Supplier::get).forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onClientSetup() {
        TINKERING_TABLE.ifPresent(container -> MenuScreens.m_96206_((MenuType)container, TinkeringTableScreen::new));
        REPROCESSOR.ifPresent(container -> MenuScreens.m_96206_((MenuType)container, ReprocessorScreen::new));
        SOUL_EXTRACTOR.ifPresent(container -> MenuScreens.m_96206_((MenuType)container, SoulExtractorScreen::new));
    }

    private static <T extends MenuType<?>> RegistryObject<T> register(String name, Supplier<? extends MenuType<?>> container) {
        ResourceLocation loc = new ResourceLocation("mysticalagriculture", name);
        ENTRIES.add(() -> (MenuType)((MenuType)container.get()).setRegistryName(loc));
        return RegistryObject.of((ResourceLocation)loc, (IForgeRegistry)ForgeRegistries.CONTAINERS);
    }
}

